<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-layer-group"></i> {$meta.lang['Bulk Generate']}</h1>
    </div>
</div>

<div class="row" style="margin-top:15px;">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-users"></i> {$meta.lang['Client Filter']}</h3></div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{$meta.lang['Client Selection']}</label>
                            <div class="radio">
                                <label><input type="radio" name="client_filter" value="all" checked> {$meta.lang['All Clients']}</label>
                            </div>
                            <div class="radio">
                                <label><input type="radio" name="client_filter" value="group"> {$meta.lang['By Client Group']}</label>
                            </div>
                            <div class="radio">
                                <label><input type="radio" name="client_filter" value="country"> {$meta.lang['By Country']}</label>
                            </div>
                            <div class="radio">
                                <label><input type="radio" name="client_filter" value="unpaid"> {$meta.lang['With Unpaid Invoices']}</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group" id="filter-value-group" style="display:none;">
                            <label>{$meta.lang['Filter Value']}</label>
                            <select class="form-control" id="filter_value">
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-calendar"></i> {$meta.lang['Date Range & Options']}</h3></div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{$meta.lang['Date From']}</label>
                            <input type="date" class="form-control" id="date_from">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{$meta.lang['Date To']}</label>
                            <input type="date" class="form-control" id="date_to">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label>{$meta.lang['Quick Period']}</label>
                        <div class="btn-group" style="margin-bottom:15px;">
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('this_month')">{$meta.lang['This Month']}</button>
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('last_month')">{$meta.lang['Last Month']}</button>
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('this_year')">{$meta.lang['This Year']}</button>
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('last_year')">{$meta.lang['Last Year']}</button>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <label>{$meta.lang['Include']}</label>
                        <div style="margin-bottom:15px;">
                            <label class="checkbox-inline"><input type="checkbox" id="include_paid" checked> {$meta.lang['Paid']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_unpaid" checked> {$meta.lang['Unpaid']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_refunded" checked> {$meta.lang['Refunded']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_transactions" checked> {$meta.lang['Transactions']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_credits" checked> {$meta.lang['Credits']}</label>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="row">
                    <div class="col-md-12">
                        <label>{$meta.lang['Actions']}</label>
                        <div style="margin-bottom:15px;">
                            <label class="checkbox-inline"><input type="checkbox" id="action_save" checked> {$meta.lang['Save to Archive']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="action_email"> {$meta.lang['Send Email']}</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <button class="btn btn-info" id="btn-count" onclick="countClients()"><i class="fa fa-calculator"></i> {$meta.lang['Count Clients']}</button>
        <button class="btn btn-success" id="btn-start" onclick="startBulk()" disabled><i class="fa fa-play"></i> {$meta.lang['Start Bulk Generate']}</button>
        <span id="count-result" style="margin-left:15px; font-size:14px;"></span>
    </div>
</div>

<div class="row" style="margin-top:20px; display:none;" id="progress-section">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-tasks"></i> {$meta.lang['Progress']}</h3></div>
            <div class="panel-body">
                <div class="progress">
                    <div class="progress-bar progress-bar-success progress-bar-striped active" id="progress-bar" role="progressbar" style="width:0%; min-width:2em;">0%</div>
                </div>
                <div id="progress-info" class="text-muted text-center"></div>
            </div>
        </div>
    </div>
</div>

<div class="row" style="margin-top:10px; display:none;" id="results-section">
    <div class="col-md-12">
        <div class="panel panel-success">
            <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-check-circle"></i> {$meta.lang['Results']}</h3></div>
            <div class="panel-body" id="results-body">
            </div>
        </div>
    </div>
</div>

{literal}
<script>
jQuery(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var totalClients = 0;
    var bulkRunning = false;

    // Client filter radio change
    var radios = document.querySelectorAll('input[name="client_filter"]');
    for (var i = 0; i < radios.length; i++) {
        radios[i].addEventListener('change', function() {
            var val = document.querySelector('input[name="client_filter"]:checked').value;
            var filterGroup = document.getElementById('filter-value-group');
            if (val === 'group' || val === 'country') {
                filterGroup.style.display = 'block';
                loadFilterValues(val);
            } else {
                filterGroup.style.display = 'none';
            }
            document.getElementById('btn-start').disabled = true;
            document.getElementById('count-result').innerHTML = '';
        });
    }

    function loadFilterValues(type) {
        var sel = document.getElementById('filter_value');
        sel.innerHTML = '<option value="">{/literal}{$meta.lang['Loading...']}{literal}</option>';

        var endpoint = type === 'group' ? 'getClientGroups' : 'getCountries';
        jQuery.ajax({
            url: ajaxUrl + '&ajax=' + endpoint,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                sel.innerHTML = '';
                if (response.success && response.data) {
                    var items = response.data;
                    if (Array.isArray(items)) {
                        for (var i = 0; i < items.length; i++) {
                            var opt = document.createElement('option');
                            opt.value = items[i].id || items[i].value || items[i].code;
                            opt.textContent = items[i].name || items[i].text || items[i].label;
                            sel.appendChild(opt);
                        }
                    }
                }
            }
        });
    }

    function formatDate(d) {
        var m = ('0' + (d.getMonth() + 1)).slice(-2);
        var day = ('0' + d.getDate()).slice(-2);
        return d.getFullYear() + '-' + m + '-' + day;
    }

    window.setQuickPeriod = function(period) {
        var now = new Date();
        var from, to;
        switch (period) {
            case 'this_month':
                from = new Date(now.getFullYear(), now.getMonth(), 1);
                to = new Date(now.getFullYear(), now.getMonth() + 1, 0);
                break;
            case 'last_month':
                from = new Date(now.getFullYear(), now.getMonth() - 1, 1);
                to = new Date(now.getFullYear(), now.getMonth(), 0);
                break;
            case 'this_year':
                from = new Date(now.getFullYear(), 0, 1);
                to = new Date(now.getFullYear(), 11, 31);
                break;
            case 'last_year':
                from = new Date(now.getFullYear() - 1, 0, 1);
                to = new Date(now.getFullYear() - 1, 11, 31);
                break;
        }
        document.getElementById('date_from').value = formatDate(from);
        document.getElementById('date_to').value = formatDate(to);
    };

    setQuickPeriod('last_month');

    function collectParams() {
        return {
            client_filter: document.querySelector('input[name="client_filter"]:checked').value,
            filter_value: document.getElementById('filter_value').value,
            date_from: document.getElementById('date_from').value,
            date_to: document.getElementById('date_to').value,
            include_paid: document.getElementById('include_paid').checked ? 1 : 0,
            include_unpaid: document.getElementById('include_unpaid').checked ? 1 : 0,
            include_refunded: document.getElementById('include_refunded').checked ? 1 : 0,
            include_transactions: document.getElementById('include_transactions').checked ? 1 : 0,
            include_credits: document.getElementById('include_credits').checked ? 1 : 0,
            action_save: document.getElementById('action_save').checked ? 1 : 0,
            action_email: document.getElementById('action_email').checked ? 1 : 0
        };
    }

    window.countClients = function() {
        var btn = document.getElementById('btn-count');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=bulkCount',
            type: 'POST',
            data: collectParams(),
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    totalClients = response.data.count || 0;
                    document.getElementById('count-result').innerHTML = '<strong>' + totalClients + '</strong> {/literal}{$meta.lang['clients matched']}{literal}';
                    document.getElementById('btn-start').disabled = (totalClients === 0);
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to count clients', 'error');
            }
        });
    };

    window.startBulk = function() {
        if (bulkRunning) return;
        if (!confirm('{/literal}{$meta.lang['Start bulk generation for']}{literal} ' + totalClients + ' {/literal}{$meta.lang['clients?']}{literal}')) return;

        bulkRunning = true;
        var btn = document.getElementById('btn-start');
        btnLoading(btn);
        document.getElementById('btn-count').disabled = true;

        document.getElementById('progress-section').style.display = 'block';
        document.getElementById('results-section').style.display = 'none';

        var params = collectParams();
        var processed = 0;
        var batchSize = 10;
        var totalBatches = Math.ceil(totalClients / batchSize);
        var currentBatch = 0;
        var totalGenerated = 0;
        var totalEmails = 0;
        var totalErrors = 0;

        function processBatch() {
            currentBatch++;
            params.batch = currentBatch;
            params.batch_size = batchSize;

            jQuery.ajax({
                url: ajaxUrl + '&ajax=bulkProcess',
                type: 'POST',
                data: params,
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.data) {
                        processed += response.data.processed || 0;
                        totalGenerated += response.data.generated || 0;
                        totalEmails += response.data.emails_sent || 0;
                        totalErrors += response.data.errors || 0;

                        var pct = Math.min(Math.round((processed / totalClients) * 100), 100);
                        document.getElementById('progress-bar').style.width = pct + '%';
                        document.getElementById('progress-bar').textContent = pct + '%';
                        document.getElementById('progress-info').textContent = processed + ' / ' + totalClients + ' {/literal}{$meta.lang['clients processed']}{literal}';

                        if (response.data.has_more && processed < totalClients) {
                            processBatch();
                        } else {
                            finishBulk();
                        }
                    } else {
                        showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                        finishBulk();
                    }
                },
                error: function() {
                    showNotification('Bulk processing failed', 'error');
                    finishBulk();
                }
            });
        }

        function finishBulk() {
            bulkRunning = false;
            btnReset(btn);
            document.getElementById('btn-count').disabled = false;

            document.getElementById('progress-bar').className = 'progress-bar progress-bar-success';
            document.getElementById('progress-bar').style.width = '100%';
            document.getElementById('progress-bar').textContent = '100%';

            document.getElementById('results-section').style.display = 'block';
            var html = '<table class="table table-bordered">';
            html += '<tr><td><strong>{/literal}{$meta.lang['Clients Processed']}{literal}</strong></td><td>' + processed + '</td></tr>';
            html += '<tr><td><strong>{/literal}{$meta.lang['Statements Generated']}{literal}</strong></td><td>' + totalGenerated + '</td></tr>';
            html += '<tr><td><strong>{/literal}{$meta.lang['Emails Sent']}{literal}</strong></td><td>' + totalEmails + '</td></tr>';
            html += '<tr><td><strong>{/literal}{$meta.lang['Errors']}{literal}</strong></td><td>' + totalErrors + '</td></tr>';
            html += '</table>';
            document.getElementById('results-body').innerHTML = html;
        }

        processBatch();
    };
});
</script>
{/literal}
